/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.OrCost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EmberwildeDjinnEffect
extends OneShotEffect {
    EmberwildeDjinnEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may pay {R}{R} or 2 life. If the player does, they gain control of {this}";
    }

    private EmberwildeDjinnEffect(EmberwildeDjinnEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmberwildeDjinnEffect copy() {
        return new EmberwildeDjinnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (player == null || sourceObject == null) {
            return false;
        }
        OrCost cost = new OrCost("{R}{R} or 2 life", new Cost[]{new ManaCostsImpl("{R}{R}"), new PayLifeCost(2)});
        if (player.chooseUse(Outcome.GainControl, "Gain control of " + sourceObject.getLogName() + "?", source, game) && cost.pay(source, game, source, player.getId(), false)) {
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, false, player.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), source.getStackMomentSourceZCC()));
            game.addEffect((ContinuousEffect)effect, source);
            player.resetStoredBookmark(game);
        }
        return true;
    }
}

