/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.common.LandfallAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EmeriaShepherdReturnToHandTargetEffect
extends OneShotEffect {
    EmeriaShepherdReturnToHandTargetEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "you may return target nonland permanent card from your graveyard to your hand. If that land is a Plains, you may return that nonland permanent card to the battlefield instead";
    }

    private EmeriaShepherdReturnToHandTargetEffect(EmeriaShepherdReturnToHandTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmeriaShepherdReturnToHandTargetEffect copy() {
        return new EmeriaShepherdReturnToHandTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent triggeringLand = ((LandfallAbility)source).getTriggeringPermanent();
        if (controller == null || triggeringLand == null) {
            return false;
        }
        Zone toZone = Zone.HAND;
        if (triggeringLand.hasSubtype(SubType.PLAINS, game) && controller.chooseUse(Outcome.PutCardInPlay, "Put the card to battlefield instead?", source, game)) {
            toZone = Zone.BATTLEFIELD;
        }
        return controller.moveCards((Cards)new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source)), toZone, source, game);
    }
}

