/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.e.EmrakulsEvangelCost;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.EldraziHorrorToken;
import mage.players.Player;

class EmrakulsEvangelEffect
extends OneShotEffect {
    EmrakulsEvangelEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Create a 3/2 colorless Eldrazi Horror creature token for each creature sacrificed this way.";
    }

    private EmrakulsEvangelEffect(EmrakulsEvangelEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmrakulsEvangelEffect copy() {
        return new EmrakulsEvangelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int tokensToCreate = 0;
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof EmrakulsEvangelCost)) continue;
                tokensToCreate = ((EmrakulsEvangelCost)cost).getNumSacrificed();
            }
            if (tokensToCreate > 0) {
                EldraziHorrorToken token = new EldraziHorrorToken();
                token.putOntoBattlefield(tokensToCreate, game, source, source.getControllerId());
            }
            return true;
        }
        return false;
    }
}

