/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class EncirclingFissurePreventEffect
extends PreventionEffectImpl {
    EncirclingFissurePreventEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, true, false);
        this.staticText = "Prevent all combat damage that would be dealt this turn by creatures target opponent controls";
    }

    private EncirclingFissurePreventEffect(EncirclingFissurePreventEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public EncirclingFissurePreventEffect copy() {
        return new EncirclingFissurePreventEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        DamageEvent damageEvent;
        return super.applies(event, source, game) && event instanceof DamageEvent && event.getAmount() > 0 && (damageEvent = (DamageEvent)event).isCombatDamage() && (permanent = game.getPermanent(damageEvent.getSourceId())) != null && permanent.isCreature(game) && permanent.isControlledBy(this.getTargetPointer().getFirst(game, source));
    }
}

