/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EndlessEvilCloneEffect
extends OneShotEffect {
    EndlessEvilCloneEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a token that's a copy of enchanted creature, except the token is 1/1";
    }

    private EndlessEvilCloneEffect(EndlessEvilCloneEffect effect) {
        super((OneShotEffect)effect);
    }

    public EndlessEvilCloneEffect copy() {
        return new EndlessEvilCloneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target;
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment != null && (target = game.getPermanentOrLKIBattlefield(enchantment.getAttachedTo())) != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, false, false, null, 1, 1, false);
            effect.setTargetPointer((TargetPointer)new FixedTarget(enchantment.getAttachedTo(), game));
            return effect.apply(game, source);
        }
        return false;
    }
}

