/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EnergyTapEffect
extends OneShotEffect {
    EnergyTapEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "Tap target untapped creature you control. If you do, add an amount of {C} equal to that creature's mana value";
    }

    private EnergyTapEffect(EnergyTapEffect effect) {
        super((OneShotEffect)effect);
    }

    public EnergyTapEffect copy() {
        return new EnergyTapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        boolean applied = false;
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null && (applied = targetCreature.tap(source, game))) {
            player.getManaPool().addMana(new Mana(0, 0, 0, 0, 0, 0, 0, targetCreature.getManaValue()), game, source);
        }
        return applied;
    }
}

