/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class EnigmaSphinxTriggeredAbility
extends TriggeredAbilityImpl {
    public EnigmaSphinxTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public EnigmaSphinxTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.ALL, effect, optional);
        this.setTriggerPhrase("When {this} is put into your graveyard from the battlefield, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private EnigmaSphinxTriggeredAbility(EnigmaSphinxTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public EnigmaSphinxTriggeredAbility copy() {
        return new EnigmaSphinxTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        Permanent permanent = zEvent.getTarget();
        return permanent != null && zEvent.isDiesEvent() && permanent.getId().equals(this.getSourceId()) && permanent.isOwnedBy(permanent.getControllerId());
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

