/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledEnchantmentPermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInLibrary;

class EnigmaticIncarnationEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledEnchantmentPermanent("another enchantment you control");

    EnigmaticIncarnationEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another enchantment. If you do, search your library for a creature card with mana value equal to 1 plus the sacrificed enchantment's mana value, put that card onto the battlefield, then shuffle.";
    }

    private EnigmaticIncarnationEffect(EnigmaticIncarnationEffect effect) {
        super((OneShotEffect)effect);
    }

    public EnigmaticIncarnationEffect copy() {
        return new EnigmaticIncarnationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || game.getBattlefield().count(filter, source.getControllerId(), source, game) == 0 || !player.chooseUse(this.outcome, "Sacrifice an enchantment?", source, game)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        game.processAction();
        int cmc = permanent.getManaValue();
        if (!permanent.sacrifice(source, game)) {
            return false;
        }
        FilterCreatureCard filterCard = new FilterCreatureCard("creature card with mana value " + (cmc + 1));
        filterCard.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, cmc + 1));
        return new SearchLibraryPutInPlayEffect(new TargetCardInLibrary((FilterCard)filterCard)).apply(game, source);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

