/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class EomerKingOfRohanEffect
extends OneShotEffect {
    EomerKingOfRohanEffect() {
        super(Outcome.Benefit);
        this.staticText = "target player becomes the monarch. {this} deals equal to its power to any target.";
    }

    private EomerKingOfRohanEffect(EomerKingOfRohanEffect effect) {
        super((OneShotEffect)effect);
    }

    public EomerKingOfRohanEffect copy() {
        return new EomerKingOfRohanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int power;
        Permanent eomer;
        Player player = game.getPlayer(((Target)source.getTargets().get(0)).getFirstTarget());
        if (player != null) {
            game.setMonarchId(source, player.getId());
        }
        if ((eomer = game.getPermanentOrLKIBattlefield(source.getSourceId())) != null && (power = eomer.getPower().getValue()) > 0) {
            game.damagePlayerOrPermanent(((Target)source.getTargets().get(1)).getFirstTarget(), power, source.getSourceId(), source, game, false, true);
        }
        return true;
    }
}

