/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.cards.e.InvestigatedWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class ErdwalIlluminatorTriggeredAbility
extends TriggeredAbilityImpl {
    public ErdwalIlluminatorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new InvestigateEffect(), false);
        this.addWatcher(new InvestigatedWatcher());
    }

    private ErdwalIlluminatorTriggeredAbility(ErdwalIlluminatorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.INVESTIGATED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        InvestigatedWatcher watcher = (InvestigatedWatcher)game.getState().getWatcher(InvestigatedWatcher.class);
        return watcher != null && watcher.getTimesInvestigated(this.getControllerId()) == 1;
    }

    public ErdwalIlluminatorTriggeredAbility copy() {
        return new ErdwalIlluminatorTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you investigate for the first time each turn, investigate an additional time.";
    }
}

