/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.ManaUtil;

class ErrantMinionEffect
extends OneShotEffect {
    ErrantMinionEffect() {
        super(Outcome.Damage);
        this.staticText = "that player may pay any amount of mana. {this} deals 2 damage to that player. Prevent X of that damage, where X is the amount of mana that player paid this way";
    }

    private ErrantMinionEffect(ErrantMinionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ErrantMinionEffect copy() {
        return new ErrantMinionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent errantMinion = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (errantMinion == null) {
            return false;
        }
        Permanent enchantedCreature = game.getPermanentOrLKIBattlefield(errantMinion.getAttachedTo());
        if (enchantedCreature == null) {
            return false;
        }
        Player controllerOfEnchantedCreature = game.getPlayer(enchantedCreature.getControllerId());
        if (controllerOfEnchantedCreature != null && controllerOfEnchantedCreature.canRespond()) {
            int manaPaid = ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Errant Minion", (Player)controllerOfEnchantedCreature, (Ability)source, (Game)game);
            if (manaPaid > 0) {
                PreventDamageToTargetEffect effect = new PreventDamageToTargetEffect(Duration.OneUse, manaPaid);
                effect.setTargetPointer((TargetPointer)new FixedTarget(controllerOfEnchantedCreature.getId()));
                game.addEffect((ContinuousEffect)effect, source);
            }
            DamageTargetEffect effect2 = new DamageTargetEffect(2);
            effect2.setTargetPointer((TargetPointer)new FixedTarget(controllerOfEnchantedCreature.getId()));
            effect2.apply(game, source);
            return true;
        }
        return false;
    }
}

