/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ErraticPortalEffect
extends OneShotEffect {
    protected Cost cost;

    public ErraticPortalEffect(Cost cost) {
        super(Outcome.Detriment);
        this.staticText = "Return target creature to its owner's hand unless its controller pays {1}";
        this.cost = cost;
    }

    private ErraticPortalEffect(ErraticPortalEffect effect) {
        super((OneShotEffect)effect);
        this.cost = effect.cost.copy();
    }

    public ErraticPortalEffect copy() {
        return new ErraticPortalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetCreature != null && (player = game.getPlayer(targetCreature.getControllerId())) != null) {
                this.cost.clearPaid();
                if (player.chooseUse(Outcome.Benefit, "Pay {1}? (Otherwise " + targetCreature.getLogName() + " will be returned to its owner's hand)", source, game)) {
                    this.cost.pay(source, game, source, targetCreature.getControllerId(), false, null);
                }
                if (!this.cost.isPaid()) {
                    controller.moveCards((Card)targetCreature, Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

