/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.PlayAdditionalLandsControllerEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.e.EscapeToTheWildsMayPlayEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EscapeToTheWildsEffect
extends OneShotEffect {
    EscapeToTheWildsEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile the top five cards of your library. You may play cards exiled this way until the end of your next turn.<br>You may play an additional land this turn.";
    }

    private EscapeToTheWildsEffect(EscapeToTheWildsEffect effect) {
        super((OneShotEffect)effect);
    }

    public EscapeToTheWildsEffect copy() {
        return new EscapeToTheWildsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 5));
        Card sourceCard = game.getCard(source.getSourceId());
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.getCards(game).stream().forEach(card -> {
            EscapeToTheWildsMayPlayEffect effect = new EscapeToTheWildsMayPlayEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
        });
        game.addEffect((ContinuousEffect)new PlayAdditionalLandsControllerEffect(1, Duration.EndOfTurn), source);
        return true;
    }
}

