/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Objects;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.game.Game;
import mage.util.CardUtil;

class EsiorWardwingFamiliarEffect
extends CostModificationEffectImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent();

    EsiorWardwingFamiliarEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Spells your opponents cast that target one or more commanders you control cost {3} more to cast";
    }

    private EsiorWardwingFamiliarEffect(EsiorWardwingFamiliarEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)3);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Set allTargets;
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        if (!game.getOpponents(source.getControllerId()).contains(abilityToModify.getControllerId())) {
            return false;
        }
        if (game.getStack().getStackObject(abilityToModify.getId()) != null) {
            allTargets = CardUtil.getAllSelectedTargets((Ability)abilityToModify, (Game)game);
        } else {
            allTargets = CardUtil.getAllPossibleTargets((Ability)abilityToModify, (Game)game);
            if (allTargets.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> !filter.match(permanent, source.getControllerId(), source, game))) {
                return false;
            }
        }
        return allTargets.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> filter.match(permanent, source.getControllerId(), source, game));
    }

    public EsiorWardwingFamiliarEffect copy() {
        return new EsiorWardwingFamiliarEffect(this);
    }

    static {
        filter.add((Predicate)CommanderPredicate.instance);
    }
}

