/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EsperTerraEffect
extends OneShotEffect {
    EsperTerraEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of target nonlegendary enchantment you control. It gains haste. If it's a Saga, put up to three lore counters on it. Sacrifice it at the beginning of your next end step";
    }

    private EsperTerraEffect(EsperTerraEffect effect) {
        super((OneShotEffect)effect);
    }

    public EsperTerraEffect copy() {
        return new EsperTerraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
        effect.setSavedPermanent(permanent);
        effect.addAdditionalAbilities(new Ability[]{HasteAbility.getInstance()});
        effect.apply(game, source);
        for (Permanent token : effect.getAddedPermanents()) {
            if (!token.hasSubtype(SubType.SAGA, game)) continue;
            Optional.ofNullable(source.getControllerId()).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(player -> player.getAmount(0, 3, "Choose how many lore counters to put on " + token.getIdName(), source, game)).filter(amount -> amount > 0).ifPresent(amount -> token.addCounters(CounterType.LORE.createInstance(amount.intValue()), source, game));
        }
        effect.removeTokensCreatedAt(game, source, false, PhaseStep.END_TURN, TargetController.YOU);
        return true;
    }
}

