/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class EssenceLeakEffect
extends OneShotEffect {
    EssenceLeakEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "sacrifice this permanent unless you pay its mana cost";
    }

    private EssenceLeakEffect(EssenceLeakEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player != null && permanent != null) {
            String message = CardUtil.replaceSourceName((String)"Pay {this}'s mana cost?", (String)permanent.getLogName());
            ManaCosts cost = permanent.getManaCost().copy();
            if (player.chooseUse(Outcome.Benefit, message, source, game)) {
                cost.clearPaid();
                if (cost.pay(source, game, source, source.getControllerId(), false, null)) {
                    return true;
                }
            }
            permanent.sacrifice(source, game);
            return true;
        }
        return false;
    }

    public EssenceLeakEffect copy() {
        return new EssenceLeakEffect(this);
    }
}

