/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EssenceVortexEffect
extends OneShotEffect {
    EssenceVortexEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy target creature unless its controller pays life equal to its toughness. A creature destroyed this way can't be regenerated.";
    }

    private EssenceVortexEffect(EssenceVortexEffect effect) {
        super((OneShotEffect)effect);
    }

    public EssenceVortexEffect copy() {
        return new EssenceVortexEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        PayLifeCost cost = new PayLifeCost(permanent.getToughness().getValue());
        if (cost.pay(source, game, source, permanent.getControllerId(), true)) {
            return true;
        }
        return permanent.destroy(source, game, true);
    }
}

