/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class EstinienVarlineauWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<UUID>> morMap = new HashMap<MageObjectReference, Set<UUID>>();
    private final Set<UUID> dragonSet = new HashSet<UUID>();

    EstinienVarlineauWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER) {
            return;
        }
        DamagedPlayerEvent dEvent = (DamagedPlayerEvent)event;
        if (!dEvent.isCombatDamage()) {
            return;
        }
        Permanent permanent = game.getPermanent(dEvent.getSourceId());
        if (permanent == null) {
            return;
        }
        this.morMap.computeIfAbsent(new MageObjectReference((MageObject)permanent, game), x -> new HashSet()).add(dEvent.getTargetId());
        if (permanent.hasSubtype(SubType.DRAGON, game)) {
            this.dragonSet.add(dEvent.getTargetId());
        }
    }

    public void reset() {
        super.reset();
        this.morMap.clear();
        this.dragonSet.clear();
    }

    static int getCount(Game game, Ability source) {
        return ((EstinienVarlineauWatcher)game.getState().getWatcher(EstinienVarlineauWatcher.class)).computeCount(game.getOpponents(source.getControllerId()), new MageObjectReference((MageObject)source.getSourcePermanentOrLKI(game), game));
    }

    private int computeCount(Set<UUID> opponents, MageObjectReference mor) {
        return opponents.stream().filter(uuid -> this.dragonSet.contains(uuid) || this.morMap.getOrDefault(mor, Collections.emptySet()).contains(uuid)).mapToInt(x -> 1).sum();
    }
}

