/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EtchedSlithEffect
extends OneShotEffect {
    EtchedSlithEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "you may remove a counter from another target permanent or opponent.";
    }

    private EtchedSlithEffect(EtchedSlithEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtchedSlithEffect copy() {
        return new EtchedSlithEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            String[] counterNames;
            for (String counterName : counterNames = permanent.getCounters(game).keySet().toArray(new String[0])) {
                if (!controller.chooseUse(Outcome.Neutral, "Remove a " + counterName + " counter?", source, game)) continue;
                permanent.removeCounters(counterName, 1, source, game);
                break;
            }
            return true;
        }
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            for (Counter counter : player.getCountersAsCopy().values()) {
                String counterName = counter.getName();
                if (!controller.chooseUse(Outcome.Neutral, "Remove a " + counterName + " counter?", source, game)) continue;
                player.loseCounters(counterName, 1, source, game);
                break;
            }
            return true;
        }
        return false;
    }
}

