/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class EternalDominionEffect
extends OneShotEffect {
    private static final FilterCard FILTER = new FilterCard("an artifact, creature, enchantment, or land card");

    public EternalDominionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search target opponent's library for an artifact, creature, enchantment, or land card. Put that card onto the battlefield under your control. Then that player shuffles";
    }

    private EternalDominionEffect(EternalDominionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        boolean applied = false;
        Player opponent = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (opponent != null && controller != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(FILTER);
            controller.searchLibrary(target, source, game, opponent.getId());
            Card targetCard = game.getCard(target.getFirstTarget());
            if (targetCard != null) {
                applied = controller.moveCards(targetCard, Zone.BATTLEFIELD, source, game);
            }
            opponent.shuffleLibrary(source, game);
        }
        return applied;
    }

    public EternalDominionEffect copy() {
        return new EternalDominionEffect(this);
    }

    static {
        FILTER.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

