/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.ForetellAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class EtherealValkyrieEffect
extends OneShotEffect {
    EtherealValkyrieEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card, then exile a card from your hand face down. It becomes foretold. Its foretell cost is its mana cost reduced by {2}";
    }

    private EtherealValkyrieEffect(EtherealValkyrieEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtherealValkyrieEffect copy() {
        return new EtherealValkyrieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.drawCards(1, source, game);
        TargetCardInHand targetCard = new TargetCardInHand(StaticFilters.FILTER_CARD).withChooseHint("to exile face down; it becomes foretold");
        if (!controller.chooseTarget(Outcome.Benefit, (Target)targetCard, source, game)) {
            return false;
        }
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card == null) {
            return false;
        }
        return ForetellAbility.doExileBecomesForetold((Card)card, (Game)game, (Ability)source, (int)2);
    }
}

