/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.cards.e.EtherswornCanonistWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class EtherswornCanonistReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    EtherswornCanonistReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Each player who has cast a nonartifact spell this turn can't cast additional nonartifact spells";
    }

    private EtherswornCanonistReplacementEffect(EtherswornCanonistReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public EtherswornCanonistReplacementEffect copy() {
        return new EtherswornCanonistReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(event.getSourceId());
        if (card != null && !card.isArtifact(game)) {
            EtherswornCanonistWatcher watcher = (EtherswornCanonistWatcher)game.getState().getWatcher(EtherswornCanonistWatcher.class);
            return watcher != null && watcher.castNonArtifactSpell(event.getPlayerId());
        }
        return false;
    }
}

