/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class EtrataFlipEffect
extends OneShotEffect {
    EtrataFlipEffect() {
        super(Outcome.Benefit);
        this.staticText = "Turn this creature face up. If you can't, exile it, then you may cast the exiled card without paying its mana cost.";
    }

    private EtrataFlipEffect(EtrataFlipEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtrataFlipEffect copy() {
        return new EtrataFlipEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean success;
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (permanent != null && player != null && !(success = permanent.turnFaceUp(source, game, source.getControllerId()))) {
            Card card = permanent.getMainCard();
            player.moveCards(card, Zone.EXILED, source, game);
            game.processAction();
            CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Card)card);
        }
        return false;
    }
}

