/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.cards.Card;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.e.EvelynTheCovetousWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.CardState;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.util.CardUtil;

class EvelynTheCovetousManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    EvelynTheCovetousManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = ", and you may spend mana as though it were any color to cast it";
    }

    private EvelynTheCovetousManaEffect(EvelynTheCovetousManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public EvelynTheCovetousManaEffect copy() {
        return new EvelynTheCovetousManaEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId) || EvelynTheCovetousWatcher.checkUsed(source, game)) {
            return false;
        }
        Card card = game.getCard(CardUtil.getMainCardId((Game)game, (UUID)sourceId));
        if (card == null) {
            return false;
        }
        if (game.getState().getZone(card.getId()) == Zone.EXILED) {
            return card.getCounters(game).getCount(CounterType.COLLECTION) > 0 && EvelynTheCovetousWatcher.checkExile(affectedControllerId, card, game, 0);
        }
        CardState cardState = card instanceof ModalDoubleFacedCard ? game.getLastKnownInformationCard(((ModalDoubleFacedCard)card).getLeftHalfCard().getId(), Zone.EXILED) : game.getLastKnownInformationCard(card.getId(), Zone.EXILED);
        return cardState != null && cardState.getCounters().getCount(CounterType.COLLECTION) > 0 && EvelynTheCovetousWatcher.checkExile(affectedControllerId, card, game, 1);
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }
}

