/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EverflameEidolonEffect
extends OneShotEffect {
    EverflameEidolonEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "{this} gets +1/+0 until end of turn. If it's an Aura, enchanted creature gets +1/+0 until end of turn instead";
    }

    private EverflameEidolonEffect(EverflameEidolonEffect effect) {
        super((OneShotEffect)effect);
    }

    public EverflameEidolonEffect copy() {
        return new EverflameEidolonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourceObject != null) {
            if (sourceObject.hasSubtype(SubType.AURA, game)) {
                game.addEffect((ContinuousEffect)new BoostEnchantedEffect(1, 0, Duration.EndOfTurn), source);
            } else {
                game.addEffect((ContinuousEffect)new BoostSourceEffect(1, 0, Duration.EndOfTurn), source);
            }
            return true;
        }
        return false;
    }
}

