/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EvolvedSleeperClericEffect
extends OneShotEffect {
    EvolvedSleeperClericEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is a Cleric, put a deathtouch counter on it and it becomes a Phyrexian Human Cleric with base power and toughness 3/3";
    }

    private EvolvedSleeperClericEffect(EvolvedSleeperClericEffect effect) {
        super((OneShotEffect)effect);
    }

    public EvolvedSleeperClericEffect copy() {
        return new EvolvedSleeperClericEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.CLERIC, game)) {
            return false;
        }
        permanent.addCounters(CounterType.DEATHTOUCH.createInstance(), source.getControllerId(), source, game);
        game.addEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.Custom, new SubType[]{SubType.PHYREXIAN, SubType.HUMAN, SubType.CLERIC}), source);
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(3, 3, Duration.Custom), source);
        return true;
    }
}

