/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EvolvedSleeperPhyrexianEffect
extends OneShotEffect {
    EvolvedSleeperPhyrexianEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is a Phyrexian, put a +1/+1 counter on it, then you draw a card and you lose 1 life";
    }

    private EvolvedSleeperPhyrexianEffect(EvolvedSleeperPhyrexianEffect effect) {
        super((OneShotEffect)effect);
    }

    public EvolvedSleeperPhyrexianEffect copy() {
        return new EvolvedSleeperPhyrexianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null || !permanent.hasSubtype(SubType.PHYREXIAN, game)) {
            return false;
        }
        if (source.getSourcePermanentIfItStillExists(game) != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        }
        Player player = game.getPlayer(source.getControllerId());
        game.processAction();
        player.drawCards(1, source, game);
        player.loseLife(1, game, source, false);
        return true;
    }
}

