/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ForestwalkAbility;
import mage.abilities.keyword.IslandwalkAbility;
import mage.abilities.keyword.MountainwalkAbility;
import mage.abilities.keyword.PlainswalkAbility;
import mage.abilities.keyword.SwampwalkAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ExcavatorEffect
extends ContinuousEffectImpl {
    private Abilities<Ability> abilities = new AbilitiesImpl();

    public ExcavatorEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.setText("Target creature gains landwalk of each of the land types of the sacrificed land until end of turn");
    }

    private ExcavatorEffect(ExcavatorEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.abilities = this.abilities.copy();
    }

    public ExcavatorEffect copy() {
        return new ExcavatorEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            SacrificeTargetCost sacrificeCost = (SacrificeTargetCost)cost;
            for (Permanent permanent : sacrificeCost.getPermanents()) {
                if (permanent.hasSubtype(SubType.FOREST, game)) {
                    this.abilities.add((Object)new ForestwalkAbility());
                }
                if (permanent.hasSubtype(SubType.PLAINS, game)) {
                    this.abilities.add((Object)new PlainswalkAbility());
                }
                if (permanent.hasSubtype(SubType.ISLAND, game)) {
                    this.abilities.add((Object)new IslandwalkAbility());
                }
                if (permanent.hasSubtype(SubType.MOUNTAIN, game)) {
                    this.abilities.add((Object)new MountainwalkAbility());
                }
                if (!permanent.hasSubtype(SubType.SWAMP, game)) continue;
                this.abilities.add((Object)new SwampwalkAbility());
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(permanentId);
            if (permanent == null) continue;
            for (Ability ability : this.abilities) {
                permanent.addAbility(ability, source.getSourceId(), game);
            }
        }
        return true;
    }
}

