/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ColorsOfManaSpentToCastCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ExertInfluenceEffect
extends OneShotEffect {
    ExertInfluenceEffect() {
        super(Outcome.GainControl);
        this.staticText = "Gain control of target creature if its power is less than or equal to the number of colors of mana spent to cast this spell";
    }

    private ExertInfluenceEffect(ExertInfluenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExertInfluenceEffect copy() {
        return new ExertInfluenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && sourceObject != null) {
            int colors = new ColorsOfManaSpentToCastCount().calculate(game, source, (Effect)this);
            if (targetCreature.getPower().getValue() <= colors) {
                game.addEffect((ContinuousEffect)new GainControlTargetEffect(Duration.Custom, true), source);
            }
            return true;
        }
        return false;
    }
}

