/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class ExhumeEffect
extends OneShotEffect {
    ExhumeEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Each player puts a creature card from their graveyard onto the battlefield";
    }

    private ExhumeEffect(ExhumeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExhumeEffect copy() {
        return new ExhumeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashSet<Card> toBattlefield = new HashSet<Card>();
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Card card;
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                FilterCreatureCard filterCreatureCard = new FilterCreatureCard("creature card from your graveyard");
                filterCreatureCard.add((Predicate)new OwnerIdPredicate(playerId));
                TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)filterCreatureCard);
                target.withNotTarget(true);
                if (!target.canChoose(playerId, source, game) || !player.chooseTarget(this.outcome, (Target)target, source, game) || (card = game.getCard(target.getFirstTarget())) == null) continue;
                toBattlefield.add(card);
            }
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, false, false, true, null);
            return true;
        }
        return false;
    }
}

