/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ExileEffect
extends OneShotEffect {
    ExileEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to its toughness";
    }

    private ExileEffect(ExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = (Permanent)game.getLastKnownInformation(source.getFirstTarget(), Zone.BATTLEFIELD);
        if (permanent != null && (player = game.getPlayer(source.getControllerId())) != null) {
            player.gainLife(permanent.getToughness().getValue(), game, source);
        }
        return false;
    }

    public ExileEffect copy() {
        return new ExileEffect(this);
    }
}

