/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.e.ExpeditedInheritanceMayPlayEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ExpeditedInheritanceExileEffect
extends OneShotEffect {
    ExpeditedInheritanceExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "its controller may exile that many cards from the top of their library. They may play those cards until the end of their next turn.";
    }

    private ExpeditedInheritanceExileEffect(ExpeditedInheritanceExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Set cards;
        String message;
        int amount = SavedDamageValue.MANY.calculate(game, source, (Effect)this);
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (amount <= 0 || player == null) {
            return false;
        }
        String string = message = amount > 1 ? "Exile " + CardUtil.numberToText((int)amount) + " cards from the top of your library. Until the end of your next turn, you may play those cards." : "Exile the top card of your library. Until the end of your next turn, you may play that card.";
        if (player.chooseUse(this.outcome, message, source, game) && !(cards = player.getLibrary().getTopCards(game, amount)).isEmpty()) {
            player.moveCards(cards, Zone.EXILED, source, game);
            for (Card card : cards) {
                ExpeditedInheritanceMayPlayEffect effect = new ExpeditedInheritanceMayPlayEffect(player.getId());
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return true;
    }

    public ExpeditedInheritanceExileEffect copy() {
        return new ExpeditedInheritanceExileEffect(this);
    }
}

