/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ExpelTheUnworthyEffect
extends OneShotEffect {
    ExpelTheUnworthyEffect() {
        super(Outcome.GainLife);
        this.staticText = ", then its controller gains life equal to its mana value";
    }

    private ExpelTheUnworthyEffect(ExpelTheUnworthyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (target == null) {
            return false;
        }
        Player player = game.getPlayer(target.getControllerId());
        if (player == null) {
            return false;
        }
        return player.gainLife(target.getManaValue(), game, source) > 0;
    }

    public ExpelTheUnworthyEffect copy() {
        return new ExpelTheUnworthyEffect(this);
    }
}

