/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class ExperimentalFrenzyRestrictionEffect
extends ContinuousRuleModifyingEffectImpl {
    ExperimentalFrenzyRestrictionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "You can't play cards from your hand";
    }

    private ExperimentalFrenzyRestrictionEffect(ExperimentalFrenzyRestrictionEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public ExperimentalFrenzyRestrictionEffect copy() {
        return new ExperimentalFrenzyRestrictionEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PLAY_LAND || event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId()) && game.getState().getZone(event.getSourceId()) == Zone.HAND;
    }
}

