/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.WeirdToken2;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class ExperimentalOverloadEffect
extends OneShotEffect {
    ExperimentalOverloadEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create an X/X blue and red Weird creature token, where X is the number of instant and sorcery cards in your graveyard. Then you may return an instant or sorcery card from your graveyard to your hand";
    }

    private ExperimentalOverloadEffect(ExperimentalOverloadEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExperimentalOverloadEffect copy() {
        return new ExperimentalOverloadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int spellCount = player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, game);
        new WeirdToken2(spellCount).putOntoBattlefield(1, game, source, source.getControllerId());
        if (spellCount < 1) {
            return true;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, true);
        player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
        return player.moveCards(game.getCard(target.getFirstTarget()), Zone.HAND, source, game);
    }
}

