/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileCardsFromTopOfLibraryControllerEffect;
import mage.abilities.effects.common.ReturnFromExileForSourceEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ExpertLevelSafeEffect
extends OneShotEffect {
    ExpertLevelSafeEffect() {
        super(Outcome.Benefit);
        this.staticText = "you and target opponent each secretly choose 1, 2, or 3. Then those choices are revealed. If they match, sacrifice {this} and put all cards exiled with it into their owners' hands. Otherwise, exile the top card of your library face down";
    }

    protected ExpertLevelSafeEffect(ExpertLevelSafeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        int controllerChoice = controller.getAmount(1, 3, "Choose a number", source, game);
        int opponentChoice = opponent.getAmount(1, 3, "Choose a number", source, game);
        game.informPlayers(controller.getLogName() + " chose " + controllerChoice);
        game.informPlayers(opponent.getLogName() + " chose " + opponentChoice);
        if (controllerChoice == opponentChoice) {
            new SacrificeSourceEffect().apply(game, source);
            new ReturnFromExileForSourceEffect(Zone.HAND).apply(game, source);
            return true;
        }
        new ExileCardsFromTopOfLibraryControllerEffect(1, true, true).apply(game, source);
        return true;
    }

    public ExpertLevelSafeEffect copy() {
        return new ExpertLevelSafeEffect(this);
    }
}

