/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Library;
import mage.players.Player;

class ExplosiveRevelationEffect
extends OneShotEffect {
    ExplosiveRevelationEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Choose any target. Reveal cards from the top of your library until you reveal a nonland card. {this} deals damage equal to that card's mana value to that permanent or player. Put the nonland card into your hand and the rest on the bottom of your library in any order";
    }

    private ExplosiveRevelationEffect(ExplosiveRevelationEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExplosiveRevelationEffect copy() {
        return new ExplosiveRevelationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            if (controller.getLibrary().hasCards()) {
                CardsImpl toReveal = new CardsImpl();
                Library library = controller.getLibrary();
                Card nonLandCard = null;
                for (Card card : library.getCards(game)) {
                    toReveal.add(card);
                    if (card.isLand(game)) continue;
                    nonLandCard = card;
                    break;
                }
                controller.revealCards(sourceObject.getIdName(), (Cards)toReveal, game);
                int damage = nonLandCard == null ? 0 : nonLandCard.getManaValue();
                for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                    Permanent targetedCreature = game.getPermanent(targetId);
                    if (targetedCreature != null) {
                        targetedCreature.damage(damage, source.getSourceId(), source, game, false, true);
                        continue;
                    }
                    Player targetedPlayer = game.getPlayer(targetId);
                    if (targetedPlayer == null) continue;
                    targetedPlayer.damage(damage, source.getSourceId(), source, game);
                }
                if (nonLandCard != null) {
                    controller.moveCards(nonLandCard, Zone.HAND, source, game);
                    toReveal.remove(nonLandCard);
                }
                return controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, true);
            }
            return true;
        }
        return false;
    }
}

