/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.e.ExterminatorMagmarchEffect;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.filter.StaticFilters;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.other.HasOnlySingleTargetPermanentPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.util.CardUtil;

class ExterminatorMagmarchTriggeredAbility
extends SpellCastControllerTriggeredAbility {
    private static final String OPPONENT_ID_KEY = "ExterminatorMagmarchOpponentKey";
    private static final FilterSpell filter = new FilterInstantOrSorcerySpell("an instant or sorcery spell that targets only a single nonland permanent an opponent controls, if another opponent controls one or more nonland permanents that spell could target");

    ExterminatorMagmarchTriggeredAbility() {
        super((Effect)new ExterminatorMagmarchEffect(), filter, false);
    }

    private ExterminatorMagmarchTriggeredAbility(ExterminatorMagmarchTriggeredAbility ability) {
        super((SpellCastControllerTriggeredAbility)ability);
    }

    public ExterminatorMagmarchTriggeredAbility copy() {
        return new ExterminatorMagmarchTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        this.getAllEffects().setValue(OPPONENT_ID_KEY, game.getSpell(event.getTargetId()).getSpellAbility().getModes().values().stream().map(Mode::getTargets).flatMap(Collection::stream).map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(Controllable::getControllerId).filter(Objects::nonNull).findFirst().orElse(null));
        return true;
    }

    public boolean checkInterveningIfClause(Game game) {
        return CardUtil.getEffectValueFromAbility((Ability)this, (String)OPPONENT_ID_KEY, UUID.class).map(opponentId -> {
            FilterNonlandPermanent filter = StaticFilters.FILTER_OPPONENTS_PERMANENT_NON_LAND.copy();
            filter.add(Predicates.not((Predicate)new ControllerIdPredicate(opponentId)));
            return game.getBattlefield().contains((FilterPermanent)filter, (Ability)this, game, 1);
        }).orElse(false);
    }

    public static String getKey() {
        return OPPONENT_ID_KEY;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)new HasOnlySingleTargetPermanentPredicate((FilterPermanent)StaticFilters.FILTER_OPPONENTS_PERMANENT_NON_LAND));
    }
}

