/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class ExtractBrainEffect
extends OneShotEffect {
    ExtractBrainEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent chooses X cards from their hand. Look at those cards. You may cast a spell from among them without paying its mana cost";
    }

    private ExtractBrainEffect(ExtractBrainEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExtractBrainEffect copy() {
        return new ExtractBrainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (controller == null || opponent == null || opponent.getHand().isEmpty() || xValue < 1) {
            return false;
        }
        TargetCard target = new TargetCard(Math.min(opponent.getHand().size(), xValue), Integer.MAX_VALUE, Zone.HAND, StaticFilters.FILTER_CARD);
        opponent.choose(Outcome.Detriment, opponent.getHand(), target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        controller.lookAtCards(source, null, (Cards)cards, game);
        CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD);
        return true;
    }
}

