/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class ExtraordinaryJourneyTriggeredAbility
extends TriggeredAbilityImpl {
    ExtraordinaryJourneyTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1, true), false);
        this.setTriggerPhrase("Whenever one or more nontoken creatures enter the battlefield, if one or more of them entered from exile or was cast from exile, ");
        this.setTriggersLimitEachTurn(1);
    }

    private ExtraordinaryJourneyTriggeredAbility(ExtraordinaryJourneyTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ExtraordinaryJourneyTriggeredAbility copy() {
        return new ExtraordinaryJourneyTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        EntersTheBattlefieldEvent zEvent = (EntersTheBattlefieldEvent)event;
        if (zEvent == null) {
            return false;
        }
        Permanent permanent = zEvent.getTarget();
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        Zone fromZone = zEvent.getFromZone();
        if (fromZone == Zone.EXILED) {
            return true;
        }
        return fromZone == Zone.STACK && (spell = game.getSpellOrLKIStack(permanent.getId())) != null && spell.getFromZone() == Zone.EXILED;
    }
}

