/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.TargetSource;

class EyeForAnEyeEffect
extends ReplacementEffectImpl {
    private final TargetSource damageSource;

    public EyeForAnEyeEffect() {
        super(Duration.EndOfTurn, Outcome.RedirectDamage);
        this.staticText = "The next time a source of your choice would deal damage to you this turn, instead that source deals that much damage to you and {this} deals that much damage to that source's controller";
        this.damageSource = new TargetSource();
    }

    private EyeForAnEyeEffect(EyeForAnEyeEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.damageSource = effect.damageSource.copy();
    }

    public EyeForAnEyeEffect copy() {
        return new EyeForAnEyeEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.damageSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        DamageEvent damageEvent = (DamageEvent)event;
        if (controller != null) {
            Player sourceController;
            controller.damage(damageEvent.getAmount(), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), damageEvent.getAppliedEffects());
            UUID sourceControllerId = game.getControllerId(damageEvent.getSourceId());
            if (sourceControllerId != null && (sourceController = game.getPlayer(sourceControllerId)) != null) {
                sourceController.damage(damageEvent.getAmount(), source.getSourceId(), source, game);
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        DamageEvent damageEvent = (DamageEvent)event;
        if (controller != null && controller.getId().equals(damageEvent.getTargetId()) && damageEvent.getSourceId().equals(this.damageSource.getFirstTarget())) {
            this.discard();
            return true;
        }
        return false;
    }
}

