/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.e.EyeOfSingularityTriggeredEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EyeOfSingularityTriggeredAbility
extends TriggeredAbilityImpl {
    EyeOfSingularityTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new EyeOfSingularityTriggeredEffect(), false);
    }

    private EyeOfSingularityTriggeredAbility(EyeOfSingularityTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public EyeOfSingularityTriggeredAbility copy() {
        return new EyeOfSingularityTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID targetId = event.getTargetId();
        Permanent permanent = game.getPermanent(targetId);
        if (event.getTargetId().equals(this.getSourceId())) {
            return false;
        }
        if (permanent != null && !permanent.isBasic(game)) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a permanent other than a basic land enters the battlefield, destroy all other permanents with that name. They can't be regenerated.";
    }
}

