/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.MaximumHandSizeControllerEffect;
import mage.constants.Duration;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.turn.Step;

class MaximumHandSizeEffect
extends MaximumHandSizeControllerEffect {
    MaximumHandSizeEffect() {
        super(Integer.MAX_VALUE, Duration.Custom, MaximumHandSizeControllerEffect.HandSizeModification.SET);
        this.staticText = "You have no maximum hand size until your next turn";
    }

    private MaximumHandSizeEffect(MaximumHandSizeEffect effect) {
        super((MaximumHandSizeControllerEffect)effect);
    }

    public boolean isInactive(Ability source, Game game) {
        return game.getPhase().getStep().getType() == PhaseStep.UNTAP && game.getStep().getStepPart() == Step.StepPart.PRE && game.isActivePlayer(source.getControllerId());
    }

    public MaximumHandSizeEffect copy() {
        return new MaximumHandSizeEffect(this);
    }
}

