/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class PutCardOnLibraryEffect
extends OneShotEffect {
    PutCardOnLibraryEffect() {
        super(Outcome.DrawCard);
        this.staticText = ", then put a card from your hand on top of your library";
    }

    private PutCardOnLibraryEffect(PutCardOnLibraryEffect effect) {
        super((OneShotEffect)effect);
    }

    public PutCardOnLibraryEffect copy() {
        return new PutCardOnLibraryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInHand target = new TargetCardInHand();
            controller.chooseTarget(Outcome.ReturnToHand, (Target)target, source, game);
            Card card = controller.getHand().get(target.getFirstTarget(), game);
            if (card != null) {
                controller.putCardsOnTopOfLibrary((Cards)new CardsImpl(card), game, source, false);
            }
            return true;
        }
        return false;
    }
}

