/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UntapAllLandsTargetEffect
extends OneShotEffect {
    private static final FilterLandPermanent filter = new FilterLandPermanent();

    public UntapAllLandsTargetEffect() {
        super(Outcome.Untap);
        this.staticText = "Target player untaps all basic lands they control";
    }

    private UntapAllLandsTargetEffect(UntapAllLandsTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            for (Permanent land : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, player.getId(), game)) {
                land.untap(game);
            }
            return true;
        }
        return false;
    }

    public UntapAllLandsTargetEffect copy() {
        return new UntapAllLandsTargetEffect(this);
    }

    static {
        filter.add((Predicate)SuperType.BASIC.getPredicate());
    }
}

