/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashMap;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class ControlledFaerieAsSpellCastWatcher
extends Watcher {
    private final FilterPermanent filter = new FilterPermanent(SubType.FAERIE, "");
    private final HashMap<MageObjectReference, Integer> permanentsWhenCast = new HashMap();

    ControlledFaerieAsSpellCastWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = game.getSpell(event.getTargetId())) != null) {
            MageObjectReference mor = new MageObjectReference((MageObject)spell, game);
            this.permanentsWhenCast.put(mor, game.getBattlefield().countAll(this.filter, spell.getControllerId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.permanentsWhenCast.clear();
    }

    public int getCount(MageObjectReference mor) {
        return this.permanentsWhenCast.getOrDefault(mor, 0);
    }
}

