/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.awt.Color;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.hint.HintUtils;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class ExileTargetsTotalManaValueCost
extends CostImpl {
    private static final FilterPermanent filter = new FilterControlledArtifactPermanent("one or more other artifacts you control with total mana value X");

    public ExileTargetsTotalManaValueCost() {
        this.text = "Exile one or more other artifacts you control with total mana value X";
    }

    public ExileTargetsTotalManaValueCost(ExileTargetsTotalManaValueCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Card abilityTarget = game.getCard(ability.getFirstTarget());
        if (abilityTarget == null) {
            return this.paid;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return this.paid;
        }
        final int minX = abilityTarget.getManaValue();
        int sum = 0;
        TargetPermanent target = new TargetPermanent(1, Integer.MAX_VALUE, filter, true){

            public String getMessage(Game game) {
                int selectedPower = this.targets.keySet().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
                String extraInfo = "(selected mana value " + selectedPower + " of " + minX + ")";
                if (selectedPower >= minX) {
                    extraInfo = HintUtils.prepareText((String)extraInfo, (Color)Color.GREEN);
                }
                return super.getMessage(game) + " " + extraInfo;
            }
        };
        if (!target.choose(Outcome.Exile, controllerId, source.getSourceId(), source, game)) {
            return this.paid;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAll((Collection)target.getTargets());
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            sum += permanent.getManaValue();
        }
        boolean bl = this.paid = sum >= minX;
        if (this.paid) {
            player.moveCardsToExile(cards.getCards(game), source, game, false, null, null);
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        int totalExileMV = 0;
        boolean anyExileFound = false;
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, controllerId, source, game)) {
            totalExileMV += permanent.getManaValue();
            anyExileFound = true;
        }
        int minTargetMV = Integer.MAX_VALUE;
        for (Card card : game.getPlayer(controllerId).getGraveyard().getCards(StaticFilters.FILTER_CARD_ARTIFACT_FROM_YOUR_GRAVEYARD, game)) {
            minTargetMV = Integer.min(minTargetMV, card.getManaValue());
        }
        return anyExileFound && totalExileMV >= minTargetMV;
    }

    public ExileTargetsTotalManaValueCost copy() {
        return new ExileTargetsTotalManaValueCost(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

