/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FadingHopeEffect
extends OneShotEffect {
    FadingHopeEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature to its owner's hand. If its mana value was 3 or less, scry 1. <i>(Look at the top card of your library. You may put that card on the bottom of your library.)</i>";
    }

    private FadingHopeEffect(FadingHopeEffect effect) {
        super((OneShotEffect)effect);
    }

    public FadingHopeEffect copy() {
        return new FadingHopeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        boolean flag = permanent.getManaValue() <= 3;
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        if (flag) {
            player.scry(1, source, game);
        }
        return true;
    }
}

