/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.PutIntoGraveFromBattlefieldThisTurnPredicate;
import mage.game.Game;
import mage.players.Player;

class FaithsRewardEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterPermanentCard();

    FaithsRewardEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return to the battlefield all permanent cards in your graveyard that were put there from the battlefield this turn";
    }

    private FaithsRewardEffect(FaithsRewardEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        return player.moveCards(player.getGraveyard().getCards(filter, source.getControllerId(), source, game), Zone.BATTLEFIELD, source, game);
    }

    public FaithsRewardEffect copy() {
        return new FaithsRewardEffect(this);
    }

    static {
        filter.add((Predicate)PutIntoGraveFromBattlefieldThisTurnPredicate.instance);
    }
}

