/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.RemoveCounterCost;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class FalcoSparaPactweaverEffect
extends AsThoughEffectImpl {
    FalcoSparaPactweaverEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.AIDontUseIt);
        this.staticText = "you may cast spells from the top of your library by removing a counter from a creature you control in addition to paying their other costs";
    }

    private FalcoSparaPactweaverEffect(FalcoSparaPactweaverEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public FalcoSparaPactweaverEffect copy() {
        return new FalcoSparaPactweaverEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card cardToCheck = game.getCard(objectId);
        if (cardToCheck == null || !source.isControlledBy(affectedControllerId) || !cardToCheck.isOwnedBy(affectedControllerId)) {
            return false;
        }
        Player player = game.getPlayer(cardToCheck.getOwnerId());
        if (player == null) {
            return false;
        }
        Card topCard = player.getLibrary().getFromTop(game);
        if (topCard == null || !topCard.getId().equals(cardToCheck.getMainCard().getId()) || cardToCheck.isLand(game)) {
            return false;
        }
        CostsImpl newCosts = new CostsImpl();
        newCosts.add((Object)new RemoveCounterCost((Target)new TargetControlledCreaturePermanent().withNotTarget(true)));
        newCosts.addAll((Collection)cardToCheck.getSpellAbility().getCosts());
        player.setCastSourceIdWithAlternateMana(cardToCheck.getId(), cardToCheck.getManaCost(), (Costs)newCosts, MageIdentifier.FalcoSparaPactweaverAlternateCast);
        return true;
    }
}

